﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager.Utilities;  

public partial class AdminListUsers : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldRegistryName.Value = Helpers.GetConfigEntry("Registry");
    }
    public override string MenuItemName()
    {
        //return "List Users";
        return "EFR ADMIN LIST USERS";
    }
    public override string AppObjectCode()
    {
        return "EFR ADMIN LIST USERS";
    }
    public override string TopMenuName()
    {
        return "Administration";
    }
    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        this.TextBoxSearchCriteria.Text = "";
        HiddenFieldClearFlag.Value = "1";
    }
    protected void OKButton_Click(object sender, EventArgs e)
    {
        GridViewUsers.PageIndex = 0;
        HiddenFieldClearFlag.Value = "0";
    }
    protected void GridViewUsers_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        switch (e.CommandName)
        {
            case "Edit":
                var index1 = Convert.ToInt32(e.CommandArgument);
                GridViewUsers.SelectedIndex = index1;
                var id1 = Convert.ToInt32(GridViewUsers.SelectedValue);

                Response.Redirect("AdminEditUsers.aspx?id={0}", id1);
                break;
            case "Edit Roles":
                var index2 = Convert.ToInt32(e.CommandArgument);
                GridViewUsers.SelectedIndex = index2;
                var id2 = Convert.ToInt32(GridViewUsers.SelectedValue);

                Response.Redirect("AdminEditUsersRoles.aspx?id={0}", id2);
                break;
        }

        GridViewUsers.SelectedIndex = -1;
    }
}
